%% EJEMPLO 12: Integracin por rechazo
% Determinar el valor de pi a partir de una integracin 2D
% Estanque circular de radio r=1 inscrito en un cuadrado de lado 2
clear

N=1e4; % Nmero de evaluaciones de la integral
Abox=2*2; % Area del cuadrado de lado 2 (2r*2r=4)

Npond=0; Nbox=0;
r=-1+(1+1)*rand(1,2*N); % Generacin de secuencia aleatoria en [-1,+1]
for i=1:N
    x(i)=r(2*i-1); y(i)=r(2*i);
    if x(i)^2+y(i)^2 < 1
        Npond=Npond+1;
    else
        Nbox=Nbox+1;
    end
end
Apond=Npond/N*Abox; % Area estimada del crculo (pi*r^2=pi)
fprintf('\n pi = %7.3f \n\n', Apond);